import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;


public class StekZadaci {
	
	// U ovom fajlu su implementirani zadaci za cije rjesavanje je najbolje koristiti strukturu stek.
	
	// Dat je izraz koji se sastoji od malih, srednjih i velikih zagrada.
	// Napisati funkciju koja provjerava da li su zagrade pravilno napisane.
	public static boolean zagrade(String izraz){
		Stack<Character> s = new Stack<Character>();
		
		for(int i = 0; i < izraz.length(); i++){
			if(izraz.charAt(i)=='(' || izraz.charAt(i)=='[' || izraz.charAt(i)=='{'){
				s.push(izraz.charAt(i)); // funkcija push() dodaje novi element na vrh operatorsa
			}else if(izraz.charAt(i)==')'){
				if(s.isEmpty() || s.peek()!='(') // funkcija peek() samo vrati element na vrhu operatorsa, ne brise ga
					return false; // ako je operators prazan ili na vrhu nije odgovarajuca otvorena zagrada izraz je nepravilan
				s.pop(); // funkcija pop() brise element sa vrha operatorsa i vraca njegovu vrijednost
			}else if(izraz.charAt(i)==']'){
				if(s.isEmpty() || s.peek()!='[')
					return false;
				s.pop();
			}else if(izraz.charAt(i)=='}'){
				if(s.isEmpty() || s.peek()!='{')
					return false;
				s.pop();
			}
		}
		
		if(!s.isEmpty())
			return false; // ako operators nije prazan na kraju to znaci da nijesu sve zagrade zatvorene i da je izraz nepravilan
		
		return true;
	}
	
	/* Napisati funkciju koja aritmeticki izraz koji se sastoji iz malih zagrada, cifara i 4 osnovne aritmeticke operacije pretvara iz infiksne u postfiksnu notaciju. 
	   Postfiksna notacija je notacija kod koje se operandi pisu prije operatora.
	   Prednost ove notacije je sto je redosljed primjene operatora definisan njihovim redosljedom i nema potrebe za koriscenjem zagrada. 
	   Samim tim lakse je napisati program koji racuna vrijednost aritmetickog izraza ako je on u postfiksnoj notaciji.
	   Primjeri:
	   		2+3 -> 23+
	   		(5+6)*2 -> 56+2*
	   		((3+2)*(5-7))/3 -> 32+57-*3/
	   
	   Za vjezbu: 
	   		1. Unaprijediti datu funkciju za izraze u kojima su prirodni brojevi sa proizvoljnim brojem cifara.
	   		   Napomena: U ovom slucaju je mozda bolje promijeniti i povratni tip funkcije da bude lista stringova a ne jedan string, zbog sljedeceg zadatka.
	   		2. Napisati funkciju koja racuna vrijednost aritmetickog izraza u postfiksnoj notaciji.
	   		   Napomena: I u ovoj funkciji je najbolje koristiti strukturu stek.
	   */
	public static String infixToPostfix(String infix){
		Stack<Character> operators = new Stack<Character>();
		
		List<Character> postfixList = new LinkedList<Character>();
		for(int i=0;i<infix.length();i++){
			char c=infix.charAt(i);
			if(c>='0' && c<='9'){
				postfixList.add(c);
			}
			else if(c=='('){
				operators.push(c);
			}
			else if(c==')'){
				// Kada naidjemo a zatvorenu zagradu, sve operatore koji se nalaze izmedju te zagrade i njoj odgovarajuce otvorene zagrade treba izbaciti sa steka na izlaz.
				// Ovime "racunamo" vrijednost izraza u zagradi.
				while(operators.peek()!='(')
				{
					char op=operators.pop();
					postfixList.add(op);
				}
				operators.pop(); // uklonimo otvorenu zagradu
			}else{
				// Kada naidjemo na neki od operatora, sve operatore koje smo procitali prije njega a koji su veceg ili jednakog prioriteta treba izbaciti sa steka na izlaz.
				// Ovo su operatori koje treba primijeniti prije trenutnog.
				while(!operators.isEmpty() && prioritet(operators.peek()) >= prioritet(c)){
					char op=operators.pop();
					postfixList.add(op);
				}
				operators.push(c); // Procitani operator guramo na stek posto smo sve one veceg ili jednakog prioriteta izbacili sa vrha steka.
			}
		}
		
		while(!operators.isEmpty()){ // Na kraju, sve operatore koji su ostali na steku prebacujemo na izlaz.
			postfixList.add(operators.pop());
		}
		
		return postfixList.toString().substring(1, 3 * postfixList.size() - 1).replaceAll(", ", ""); 
	}
	
	public static int prioritet(char operator){
		if(operator=='(')
			return 0;
		if(operator=='+' || operator=='-')
			return 1;
		if(operator=='*' || operator=='/')
			return 2;
		
		return 0;
	}
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		System.out.println(zagrade("()[(){}]"));
		System.out.println(infixToPostfix("(5+6)*2"));
		System.out.println(infixToPostfix("((3+2)*(5-7))/3"));
	}

}
